/*
 * Decompiled with CFR 0.152.
 */
package mod.traister101.sns.common.capability;

import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public class LazyCapabilityProvider<Handler>
implements ICapabilityProvider {
    private final HandlerFactory<Handler> handlerFactory;
    private final Capability<? super Handler>[] capabilities;
    @Nullable
    protected Handler handler;
    @Nullable
    private LazyOptional<Handler> holder;

    @SafeVarargs
    public LazyCapabilityProvider(HandlerFactory<Handler> handlerFactory, Capability<? super Handler> ... capabilities) {
        this.capabilities = capabilities;
        this.handlerFactory = handlerFactory;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        for (Capability<? super Handler> capability : this.capabilities) {
            if (capability != cap) continue;
            return this.getHolder().cast();
        }
        return LazyOptional.empty();
    }

    protected final LazyOptional<Handler> getHolder() {
        if (this.holder == null) {
            this.holder = LazyOptional.of(this::getHandler);
        }
        return this.holder;
    }

    protected final Handler getHandler() {
        if (this.handler == null) {
            this.handler = this.handlerFactory.create();
        }
        return this.handler;
    }

    @FunctionalInterface
    public static interface HandlerFactory<Handler> {
        @Nonnull
        public Handler create();
    }

    public static final class LazySerializedCapabilityProvider<Handler extends INBTSerializable<CompoundTag>>
    extends LazyCapabilityProvider<Handler>
    implements INBTSerializable<CompoundTag> {
        @SafeVarargs
        public LazySerializedCapabilityProvider(HandlerFactory<Handler> handlerFactory, Capability<? super Handler> ... capabilities) {
            super(handlerFactory, capabilities);
        }

        public CompoundTag serializeNBT() {
            return (CompoundTag)((INBTSerializable)this.getHandler()).serializeNBT();
        }

        public void deserializeNBT(CompoundTag compoundTag) {
            ((INBTSerializable)this.getHandler()).deserializeNBT((Tag)compoundTag);
        }
    }
}

